//*********************************************************************************
// SprMaker.cpp - Main functions
//
// Half-Life Sprite Maker - Written by David Flor, (c) 1999 Mach III Enterprises
//*********************************************************************************
// Most of the below functions were created for the most part by the AppWizard
//  provided by Microsoft Visual C++ v6.0. I don't usually like to use wizards,
//  but sometimes it saves a lot of time...
//*********************************************************************************

#include "stdafx.h"
#include "sprmake.h"

#define		VERSION				"1.01"

int gTransparencyMode = SPR_NORMAL;
static int gGlobalError = 0;

static TBMPArray *ReadBMPArray(char *baseName)
{
	TBMPArray		*sData;
	char			tStr[256];
	int				result = 0;
	bitmap_struct	bData;
	char			*tPtr;

	tPtr = strchr(baseName, '.');
	if (tPtr)
		*tPtr = 0;	

	sData = new TBMPArray();
	if (sData)
	{
		long Cnt = 1;

		for (;;)
		{
			sprintf(tStr, "%s%03d.BMP", baseName, Cnt);
			result = LoadBMP(tStr, &bData);
			if (result == -1)
				break;

			if (result < 0)
			{
				gGlobalError = result;
				delete sData;
				return NULL;
			}

			if (Cnt > 1)
			{
				if (bData.ppbPalette)
				{
					free(bData.ppbPalette);
					bData.ppbPalette = NULL;
				}
			}

			sData->AddBMPData(&bData);
			Cnt++;
		}

		if (sData->spriteData.numframes == 0)
		{
			printf("Unable to open initial BMP file!\n");
			delete sData;
			gGlobalError = -1;
			return NULL;
		}

		printf("%d BMP files read...\n", sData->spriteData.numframes);
	}

	return sData;
}

#define		BadWrite(_dPtr, _dSize, _fp)	((long)fwrite((_dPtr), 1, (long)(_dSize), _fp) != (long)(_dSize))

static int WriteOutSprite(char *outName, TBMPArray *sData)
{
	char				fileName[256];
	FILE				*fp;
	short				tCnt;
	TBMPData			*cFrame;
	dspriteframetype_t	fType;

	sprintf(fileName, "%s.SPR", outName);

	if (!(sData->bmpData))
	{
		printf("No frames to save!\n");
		return -2;
	}

	fp = fopen(fileName, "wb");
	if (!fp)
	{
		printf("Cannot open target file!\n");
		return -1;
	}

	if (BadWrite(&(sData->spriteData), sizeof(dsprite_t), fp))
		goto WriteError;

	tCnt = 0x0100;
	if (BadWrite(&tCnt, sizeof(short), fp))
		goto WriteError;

	cFrame = sData->bmpData;
	fType.type = SPR_SINGLE;

	if (BadWrite(cFrame->bData.ppbPalette, 0x0300, fp))
		goto WriteError;

	while (cFrame)
	{
		if (BadWrite(&fType, sizeof(dspriteframetype_t), fp))
			goto WriteError;

		if (BadWrite(&(cFrame->fData), sizeof(dspriteframe_t), fp))
			goto WriteError;

		if (BadWrite(cFrame->bData.ppbBits, (cFrame->fData.width * cFrame->fData.height), fp))
			goto WriteError;

		cFrame = cFrame->next;
	}

	fclose(fp);
	
	printf("\"%s\" saved!\n", fileName);

	return 0;

WriteError:
	if (fp)
		fclose(fp);

	printf("Error writing to output file (out of space?)\n");

	return -3;
}

static void DisplayCredits(void)
{
	printf("=====================================================\n");
	printf("             Half-Life SpriteMaker v%s\n", VERSION);
	printf("=====================================================\n");
	printf("Writen by David Flor - (c) 1999 Mach III Enterprises\n");
	printf("        http://www.planethalflife.com/mach3/\n");
	printf("=====================================================\n\n");
}

static void DisplayUsage(void)
{
	printf("Usage:\n");
	printf("   sprmake <-t 0-3> filename\n\n");
	printf(" -t: Transparency method\n");
	printf("   0: Normal (default)\n");
	printf("   1: Additive (full color texture, to be blended with additive transparency)\n");
	printf("   2: Index Alpha (full color, palette index is alpha)\n");
	printf("   3: Alpha Test (full color, 255 is a hole)\n\n");
	printf(" <filename> (REQUIRED): Base filename of sequentially numbered BMP files\n");
	printf(" Output sprite name will be base filename with \".SPR\" extension.\n\n");

	printf("CURRENT LIMITATIONS in v%s:\n", VERSION);
	printf(" - All bitmaps must be 8-bit\n");
	printf(" - All frames use the color table of the FIRST bitmap.\n");
}

int main(int argc, char* argv[])
{
	TBMPArray	*sData;
	char		*fileName = argv[1];

	DisplayCredits();
	if (argc <= 1)
		gGlobalError = -2000;

	if (!gGlobalError)
	{
		if (!stricmp(fileName, "-t"))
		{
			char *tPtr = argv[2];

			if (!tPtr)
				gGlobalError = -818;
			else if (!(*tPtr))
				gGlobalError = -818;
			else
			{
				gTransparencyMode = (*tPtr) - '0';
				if ((gTransparencyMode < 0) || (gTransparencyMode > 3))
					gTransparencyMode = 0;
				fileName = argv[3];
			}
		}

		if (fileName)
		{
			if (*fileName)
			{
				sData = ReadBMPArray(fileName);		
				if (sData)
				{
					gGlobalError = WriteOutSprite(fileName, sData);
					delete sData;
				}
			}
			else
				gGlobalError = -818;
		}
		else
			gGlobalError = -818;
	}

	if (gGlobalError)
	{
		if (gGlobalError = -818)
			printf("Invalid parameters!\n");
		DisplayUsage();
	}

	return gGlobalError;
}

